/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.formatter;

import beaver.Parser;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.formatter.CSSFormatterContext;
import com.aptana.editor.css.formatter.CSSFormatterNodeBuilder;
import com.aptana.editor.css.formatter.CSSFormatterNodeRewriter;
import com.aptana.editor.css.formatter.CSSFormatterPlugin;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    private static final Pattern whiteSpaceAsterisk = Pattern.compile("[\\s\\*]");
    protected static final String[] SPACES = new String[]{"css.formatter.spaces.after.child.combinator", "css.formatter.spaces.after.commas", "css.formatter.spaces.after.parentheses", "css.formatter.spaces.after.colon", "css.formatter.spaces.after.semicolon", "css.formatter.spaces.before.child.combinator", "css.formatter.spaces.before.commas", "css.formatter.spaces.before.parentheses", "css.formatter.spaces.before.colon", "css.formatter.spaces.before.semicolon"};

    protected CSSFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)source).getRootNode();
            if (parseResult != null) {
                CSSFormatterNodeBuilder builder = new CSSFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new CSSFormatterNodeRewriter(parseResult, formatterDocument).rewrite(root);
                CSSFormatterContext context = new CSSFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        block6: {
            String input = new String(source.substring(offset, offset + length));
            try {
                String output;
                IParseRootNode parseResult = null;
                parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)input).getRootNode();
                if (parseResult == null || (output = this.format(input, parseResult, indentationLevel, offset, isSelection, indentSufix, offset != 0, length != source.length())) == null) break block6;
                if (!input.equals(output)) {
                    if (this.equalsIgnoreWhiteSpaceAndAsterisk(input, output)) {
                        return new ReplaceEdit(offset, length, output);
                    }
                    this.logError(input, output);
                    break block6;
                }
                return new MultiTextEdit();
            }
            catch (Parser.Exception e) {
                StatusLineMessageTimerManager.setErrorMessage((String)NLS.bind((String)FormatterMessages.Formatter_formatterParsingErrorStatus, (Object)e.getMessage()), (long)3000L, (boolean)true);
                if (FormatterPlugin.getDefault().isDebugging()) {
                    IdeLog.logError((Plugin)CSSFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
                }
            }
            catch (Exception e) {
                StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
                IdeLog.logError((Plugin)CSSFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
        }
        return null;
    }

    public int getIndentSize() {
        return this.getInt("css.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("css.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("css.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)CSSPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)CSSPlugin.getDefault().getPreferenceStore());
    }

    private String format(String input, IParseRootNode parseResult, int indentationLevel, int offset, boolean isSelection, String indentSufix, boolean prefixWithNewLine, boolean postfixWithNewLine) throws Exception {
        CSSFormatterNodeBuilder builder = new CSSFormatterNodeBuilder();
        FormatterDocument document = this.createFormatterDocument(input, offset);
        IFormatterContainerNode root = builder.build((IParseNode)parseResult, document);
        new CSSFormatterNodeRewriter(parseResult, document).rewrite(root);
        CSSFormatterContext context = new CSSFormatterContext(indentationLevel);
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineSeparator, this.createIndentGenerator());
        writer.setWrapLength(this.getInt("css.formatter.wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("css.formatter.line.preserve"));
        root.accept((IFormatterContext)context, (IFormatterWriter)writer);
        writer.flush((IFormatterContext)context);
        String output = writer.getOutput();
        List offOnRegions = builder.getOffOnRegions();
        if (offOnRegions != null && !offOnRegions.isEmpty()) {
            List outputOnOffRegions = this.getOutputOnOffRegions(output, this.getString("css.formatter.formatter.off"), this.getString("css.formatter.formatter.on"));
            output = FormatterUtils.applyOffOnRegions((String)input, (String)output, (List)offOnRegions, (List)outputOnOffRegions);
        }
        if (output.length() > 0) {
            if (prefixWithNewLine && !output.startsWith(this.lineSeparator)) {
                output = String.valueOf(this.lineSeparator) + output;
            }
            if (postfixWithNewLine && !output.endsWith(this.lineSeparator)) {
                output = String.valueOf(output) + this.lineSeparator;
            }
            output = String.valueOf(output) + indentSufix;
        }
        return output;
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("css.formatter.formatter.tabulation.size", this.getInt("css.formatter.formatter.tabulation.size"));
        document.setBoolean("css.formatter.wrap.comments", this.getBoolean("css.formatter.wrap.comments"));
        document.setString("css.formatter.indent.blocks", this.getString("css.formatter.indent.blocks"));
        document.setInt("css.formatter.line.after.element", this.getInt("css.formatter.line.after.element"));
        document.setInt("css.formatter.line.after.declaration", this.getInt("css.formatter.line.after.declaration"));
        document.setInt("formatting.context.originalOffset", offset);
        document.setBoolean("css.formatter.formatter.on.off.enabled", this.getBoolean("css.formatter.formatter.on.off.enabled"));
        document.setString("css.formatter.formatter.on", this.getString("css.formatter.formatter.on"));
        document.setString("css.formatter.formatter.off", this.getString("css.formatter.formatter.off"));
        String[] stringArray = SPACES;
        int n = SPACES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            document.setInt(key, this.getInt(key));
            ++n2;
        }
        return document;
    }

    private boolean equalsIgnoreWhiteSpaceAndAsterisk(String in, String out) {
        if (in == null || out == null) {
            return in == out;
        }
        boolean result = (in = whiteSpaceAsterisk.matcher(in).replaceAll("")).equals(out = whiteSpaceAsterisk.matcher(out).replaceAll(""));
        if (!result && FormatterPlugin.getDefault().isDebugging()) {
            FormatterUtils.logDiff((String)in, (String)out);
        }
        return result;
    }
}

